clc, clear, close all

fplot( @(x) -sin(pi*x)/x,[-5 5],'LineW',2), hold on,
axis equal, grid on, grid minor
plot([-5 5],[0 0],'-k')
f = gcf; f.Color = 'w';

x = [0.35,0.5];
y = [0.4,0.3];
a = text(-3.2,-2.4,{'Effective solution:';'x= 0';'f(x)= -\pi'},'Color','b',...
             'BackgroundColor','w','EdgeCol','k');

%%
global h
failureSet = [-4.2 -2.3 -1.1 1.3 2.6 4.3]';
randomSet = rand(6,1)*5;
options = optimoptions( @ga, 'PopulationSize',6, 'MaxGenerations',100,...
            'OutputFcn',@gaoutfun,'InitialPopulation',failureSet,...
            'MigrationFraction',0.1,'CrossoverFraction',0.1);
targetFcn = @(x) -sin(pi.*x)./x;
[sol, fval, exfl, outp, pop, scores] = ga(@(z) targetFcn(z),1,[],[],[],[],...
                -5,5,[],[],options);

%%
% vv = nan(1,8*3);
% vx = vv; vx(1:3:end)=h(1).pop; vx(2:3:end)=h(1).pop;
% vy = vv; vy(1:3:end)=0; vy(2:3:end)=h(1).score;

Plo = stem(h(1).pop, h(1).score,'LineWidth',1.5);
%
ylabel("sin(\pi\cdotx) / x")
for i=1:length(h)
   Plo.XData = h(i).pop;
   Plo.YData = h(i).score;
   Plo.Color = rand(1,3);
   [y,x]=min(h(i).score,[],1); x=h(i).pop(x);
   title({"GA generation: "+i; "best x= "+x+"    with f(x)= "+y});

   drawnow
   pause(0.05+0.2*(std(h(i).pop)>0.5))
   
    frame = getframe(f); 
    im = frame2im(frame); 
    [imind,cm] = rgb2ind(im,256); 
    % Write to the GIF File 
    fileName = 'GAfailure.gif';
    if i == 1 
        imwrite(imind,cm,fileName,'gif', 'Loopcount',inf); 
    else 
        imwrite(imind,cm,fileName,'gif','WriteMode','append',...
            'DelayTime',0.05+0.2*(std(h(i).pop)>0.5)); 
    end 
end
text(x+0.2,y+(y<3),["GA solution:"; "x= "+x; "f(x)= "+y],'Color',Plo.Color,...
             'BackgroundColor','w','EdgeCol','k');

frame = getframe(f); 
im = frame2im(frame); 
[imind,cm] = rgb2ind(im,256); 
imwrite(imind,cm,fileName,'gif','WriteMode','append','DelayTime',1); 

%% 
function [state,options,optchanged]=gaoutfun(options, state, flag)
 global h
 optchanged = false;
 switch flag
     case 'init'
         h = struct('pop',{state.Population},'score',state.Score,...
                  'best',min(state.Score), 'mean', mean(state.Score));
     otherwise
        h(end+1).pop   = state.Population;
        h(end).score = state.Score;
        h(end).best  = min(state.Score);
        h(end).mean  = mean(state.Score);
 end
end